function sysconf(sys,E)

% Olivier Pujol : septembre 2013

if (nargin~=2);error('Mauvais nombre d''arguments d''entre !');end
if (isa(sys,'cell')==0),error('Le premier argument doit tre du type ''cellule'' !');end
%
%% Calcul de la matrice de transfert abcd du puits

TES=matrix(sys);

%% Extraction de l'lment d

d=nan(1,length(TES));   % Initialisation

for iT=1:size(TES,2)
    d(iT)=TES{iT}(2,2);   % Elment d
end

clear TES

%% Partie graphique (affichage des tats confins d'nergie)

%   Affichage du puits
L=get(sys{1}{length(sys{1})},'Position')-get(sys{1}{2},'Position'); % Largeur du puits
xmin=get(sys{1}{2},'Position')-0.5*L;                       % Minimum de l'intervalle de trac (selon Ox) 
xmax=get(sys{1}{length(sys{1})},'Position')+0.5*L;          % Maximum de l'intervalle de trac (selon Ox) 

pos=nan(1,length(sys{1})-1);    % Initialisation de la position des marches
Ep=nan(1,length(sys{1})-1);     % Initialisation de la hauteur des marches
%
for i=2:length(sys{1})
    if (isa(sys{1}{i},'marche')==0),error('Mauvais type d''argument !');end
    pos(i-1)=get(sys{1}{i},'Position');
    Ep(i-1)=get(sys{1}{i},'EnergiePotentielleSortie');
end
%
pos=[xmin pos xmax];
Ep_e=sys{1}{1}(1);
Ep_s=sys{1}{1}(2);
Ep=[Ep_e Ep Ep_s];

figure
subplot(1,2,1)
hs=stairs(pos,Ep);              % Affichage du puits
set(hs,'LineWidth',2,'Color','b');
% axis([xmin xmax min(Ep) max(Ep)]);
%axis([xmin xmax min(E)-0.1*abs(min(Ep)) max(E)]);
if (min(Ep)<0),axis([xmin xmax min(Ep) max(E)+0.1*abs(min(Ep))]);end
if (min(Ep)>=0),axis([xmin xmax min(Ep) max(E)+0.1*max(E)]);end
set(gca,'xminortick','on','yminortick','on');
grid on;
box on;
xlabel('{\itx} (nm)');
ylabel('{\it E} (eV)');
title('{Puits d''nergie potentielle}');

%   Affichage des tats confins d'nergie. Ils sont obtenus en principe
%   pour d=0. En pratique, on considre les minima de d, car le nombre fini
%   de valeurs de l'nergie E et les approximations numriques empchent 
%   d'obtenir rigoureusement une valeur nulle pour d. En outre, afin de
%   mieux faire ressortir ces minima, il est parfois prfrable de tracer le logarithme
%   nprien de la valeur absolue de d.
subplot(1,2,2);
plot(log(abs(d)),E,'b');
% % % % [vaxes,c1,c2]=plotyy(log(abs(d)),E,log(abs(d)),E-min(Ep));
% % % % set(c1,'Color','b');
% % % % set(c2,'Color','b');
if (min(Ep)<0),axis([min(log(abs(d))) max(log(abs(d))) min(Ep) max(E)+0.1*abs(min(Ep))]);end
if (min(Ep)>=0),axis([min(log(abs(d))) max(log(abs(d))) min(Ep) max(E)+0.1*max(E)]);end
%axis([min(log(abs(d))) max(log(abs(d))) min(Ep) max(E)+0.1*max(E)]); 
set(gca,'xminortick','on','yminortick','on');
grid on;
box on
title('Etats confins d''nergie');
xlabel('ln |d|');
% % % % axes(vaxes(1))
% set(vaxes(1),'YColor','k','XLim',[min(log(abs(d))) max(log(abs(d)))],'YLim',[min(Ep) max(E)])
% % % % set(vaxes(1),'YColor','k','XLim',[min(log(abs(d))) max(log(abs(d)))],'YLim',[min(E) max(E)])
ylabel('{\it E} (eV)','Color','k');
% % % % axes(vaxes(2))
% set(vaxes(2),'YColor','k','XLim',[min(log(abs(d))) max(log(abs(d)))],'YLim',[min(Ep)-min(Ep) max(E)-min(Ep)])
% % % % set(vaxes(2),'YColor','k','XLim',[min(log(abs(d))) max(log(abs(d)))],'YLim',[min(E)-min(Ep) max(E)-min(Ep)])
% % % % ylabel('Energie (eV) avec origine au fond du puits','Color','k');

return;
